# team-member-server-sdk
Mentortools service for Team Members

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0+2293462583
- Generator version: 7.19.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import team_member_server_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import team_member_server_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import team_member_server_sdk
from team_member_server_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = team_member_server_sdk.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ServerName Authorization
configuration.api_key['ServerName Authorization'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ServerName Authorization'] = 'Bearer'


# Enter a context with an instance of the API client
async with team_member_server_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = team_member_server_sdk.ServerRequestsApi(api_client)
    activate_team_member_request = team_member_server_sdk.ActivateTeamMemberRequest() # ActivateTeamMemberRequest | 

    try:
        # Activate Team Member
        api_response = await api_instance.activate_team_member_v1_team_member_activate_post(activate_team_member_request)
        print("The response of ServerRequestsApi->activate_team_member_v1_team_member_activate_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ServerRequestsApi->activate_team_member_v1_team_member_activate_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ServerRequestsApi* | [**activate_team_member_v1_team_member_activate_post**](docs/ServerRequestsApi.md#activate_team_member_v1_team_member_activate_post) | **POST** /v1/team_member/activate | Activate Team Member
*ServerRequestsApi* | [**get_team_member_access_v1_team_member_access_get_post**](docs/ServerRequestsApi.md#get_team_member_access_v1_team_member_access_get_post) | **POST** /v1/team_member/access/get | Get Team Member access
*ServerRequestsApi* | [**get_team_members_v1_team_member_list_post**](docs/ServerRequestsApi.md#get_team_members_v1_team_member_list_post) | **POST** /v1/team_member/list | Get Team Members
*TeamMemberApi* | [**activate_team_member_v1_team_member_activate_post**](docs/TeamMemberApi.md#activate_team_member_v1_team_member_activate_post) | **POST** /v1/team_member/activate | Activate Team Member
*TeamMemberApi* | [**disable_team_member_v1_team_member_disable_post**](docs/TeamMemberApi.md#disable_team_member_v1_team_member_disable_post) | **POST** /v1/team_member/disable | Disable Team Member
*TeamMemberApi* | [**enable_team_member_v1_team_member_enable_post**](docs/TeamMemberApi.md#enable_team_member_v1_team_member_enable_post) | **POST** /v1/team_member/enable | Enable Team Member
*TeamMemberApi* | [**get_team_member_access_v1_team_member_access_get_post**](docs/TeamMemberApi.md#get_team_member_access_v1_team_member_access_get_post) | **POST** /v1/team_member/access/get | Get Team Member access
*TeamMemberApi* | [**get_team_members_amount_v1_team_member_count_post**](docs/TeamMemberApi.md#get_team_members_amount_v1_team_member_count_post) | **POST** /v1/team_member/count | Get Team Members amount
*TeamMemberApi* | [**get_team_members_v1_team_member_list_post**](docs/TeamMemberApi.md#get_team_members_v1_team_member_list_post) | **POST** /v1/team_member/list | Get Team Members
*TeamMemberApi* | [**invite_team_member_v1_team_member_invite_post**](docs/TeamMemberApi.md#invite_team_member_v1_team_member_invite_post) | **POST** /v1/team_member/invite | Invite new Team Member
*TeamMemberApi* | [**remove_team_members_v1_team_member_delete_post**](docs/TeamMemberApi.md#remove_team_members_v1_team_member_delete_post) | **POST** /v1/team_member/delete | Remove Team Member
*TeamMemberApi* | [**resend_invitation_email_v1_team_member_email_resend_post**](docs/TeamMemberApi.md#resend_invitation_email_v1_team_member_email_resend_post) | **POST** /v1/team_member/email/resend | Resend invitation email
*TeamMemberApi* | [**update_team_members_v1_team_member_update_post**](docs/TeamMemberApi.md#update_team_members_v1_team_member_update_post) | **POST** /v1/team_member/update | Update Team Member
*TeamMemberRoleApi* | [**add_team_member_role_v1_team_member_role_add_post**](docs/TeamMemberRoleApi.md#add_team_member_role_v1_team_member_role_add_post) | **POST** /v1/team_member/role/add | Add Team Member role
*TeamMemberRoleApi* | [**get_team_member_roles_v1_team_member_role_list_post**](docs/TeamMemberRoleApi.md#get_team_member_roles_v1_team_member_role_list_post) | **POST** /v1/team_member/role/list | Get Team Member roles
*TeamMemberRoleApi* | [**remove_team_member_role_v1_team_member_role_delete_post**](docs/TeamMemberRoleApi.md#remove_team_member_role_v1_team_member_role_delete_post) | **POST** /v1/team_member/role/delete | Remove Team Member role
*TeamMemberRoleApi* | [**update_team_member_role_actions_v1_team_member_role_action_update_post**](docs/TeamMemberRoleApi.md#update_team_member_role_actions_v1_team_member_role_action_update_post) | **POST** /v1/team_member/role/action/update | Update Team Member role actions
*TeamMemberRoleApi* | [**update_team_member_role_entity_settings_v1_team_member_role_entity_settings_update_post**](docs/TeamMemberRoleApi.md#update_team_member_role_entity_settings_v1_team_member_role_entity_settings_update_post) | **POST** /v1/team_member/role/entity/settings/update | Update Team Member role entity settings
*TeamMemberRoleApi* | [**update_team_member_role_v1_team_member_role_update_post**](docs/TeamMemberRoleApi.md#update_team_member_role_v1_team_member_role_update_post) | **POST** /v1/team_member/role/update | Update Team Member role


## Documentation For Models

 - [ActionCode](docs/ActionCode.md)
 - [ActionOperation](docs/ActionOperation.md)
 - [ActionToUpdate](docs/ActionToUpdate.md)
 - [ActivateTeamMemberRequest](docs/ActivateTeamMemberRequest.md)
 - [AddTeamMemberRoleRequest](docs/AddTeamMemberRoleRequest.md)
 - [DisableTeamMemberRequest](docs/DisableTeamMemberRequest.md)
 - [EnableTeamMemberRequest](docs/EnableTeamMemberRequest.md)
 - [EntitySettingsToUpdate](docs/EntitySettingsToUpdate.md)
 - [EntityType](docs/EntityType.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [InviteTeamMemberRequest](docs/InviteTeamMemberRequest.md)
 - [LocationInner](docs/LocationInner.md)
 - [PortalMemberSchema](docs/PortalMemberSchema.md)
 - [RemoveTeamMemberRequest](docs/RemoveTeamMemberRequest.md)
 - [RemoveTeamMemberRoleRequest](docs/RemoveTeamMemberRoleRequest.md)
 - [ResendInvitationEmailRequest](docs/ResendInvitationEmailRequest.md)
 - [ScopeSchema](docs/ScopeSchema.md)
 - [SettingsOperation](docs/SettingsOperation.md)
 - [TeamMemberAccessResponse](docs/TeamMemberAccessResponse.md)
 - [TeamMemberActionsRequest](docs/TeamMemberActionsRequest.md)
 - [TeamMemberAmountRequest](docs/TeamMemberAmountRequest.md)
 - [TeamMemberRequest](docs/TeamMemberRequest.md)
 - [TeamMemberResponse](docs/TeamMemberResponse.md)
 - [TeamMemberRoleResponse](docs/TeamMemberRoleResponse.md)
 - [TeamMemberRoleSchema](docs/TeamMemberRoleSchema.md)
 - [TeamMemberRoleValuesToUpdate](docs/TeamMemberRoleValuesToUpdate.md)
 - [TeamMemberValuesToUpdate](docs/TeamMemberValuesToUpdate.md)
 - [UpdateTeamMemberRequest](docs/UpdateTeamMemberRequest.md)
 - [UpdateTeamMemberRoleActionsRequest](docs/UpdateTeamMemberRoleActionsRequest.md)
 - [UpdateTeamMemberRoleEntitySettingsRequest](docs/UpdateTeamMemberRoleEntitySettingsRequest.md)
 - [UpdateTeamMemberRoleRequest](docs/UpdateTeamMemberRoleRequest.md)
 - [ValidationError](docs/ValidationError.md)
 - [WrappedResponseInt](docs/WrappedResponseInt.md)
 - [WrappedResponseListTeamMemberResponse](docs/WrappedResponseListTeamMemberResponse.md)
 - [WrappedResponseListTeamMemberRoleResponse](docs/WrappedResponseListTeamMemberRoleResponse.md)
 - [WrappedResponseTeamMemberAccessResponse](docs/WrappedResponseTeamMemberAccessResponse.md)
 - [WrappedResponseTeamMemberResponse](docs/WrappedResponseTeamMemberResponse.md)
 - [WrappedResponseTeamMemberRoleResponse](docs/WrappedResponseTeamMemberRoleResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Bearer Authorization"></a>
### Bearer Authorization

- **Type**: Bearer authentication

<a id="ServerName Authorization"></a>
### ServerName Authorization

- **Type**: API key
- **API key parameter name**: server_name
- **Location**: HTTP header


## Author




