#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from enum import StrEnum


class ParameterStyle(StrEnum):
    """
    Example with values
    string = "blue"
    array  = ["blue","black","brown"]
    object = {"R": 100, "G": 200, "B": 150}
    """

    matrix = 'matrix'
    # explode=False     ;color      ;color=blue     ;color=blue,black,brown                 ;color=R,100,G,200,B,150
    # explode=True      ;color      ;color=blue     ;color=blue;color=black;color=brown     ;R=100;G=200;B=150
    label = 'label'
    # explode=False     .           .blue           .blue.black.brown                       .R.100.G.200.B.150
    # explode=True      .           .blue           .blue.black.brown                       .R=100.G=200.B=150
    form = 'form'
    # explode=False     color=      color=blue      color=blue,black,brown                  color=R,100,G,200,B,150
    # explode=True      color=      color=blue      color=blue&color=black&color=brown      R=100&G=200&B=150
    simple = 'simple'
    # explode=False     n/a         blue            blue,black,brown                        R,100,G,200,B,150
    # explode=True      n/a         blue            blue,black,brown                        R=100,G=200,B=150
    spaceDelimited = 'spaceDelimited'
    # explode=False     n/a         n/a   	        blue%20black%20brown                    R%20100%20G%20200%20B%20150
    pipeDelimited = 'pipeDelimited'
    # explode=False     n/a         n/a             blue|black|brown                        R|100|G|200|B|150
    deepObject = 'deepObject'
    # explode=True      n/a         n/a             n/a                         color[R]=100&color[G]=200&color[B]=150
