# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, conlist
from chat_server_connector.models.chat_get_with_members import ChatGetWithMembers
from chat_server_connector.models.chat_message_read import ChatMessageRead
from chat_server_connector.models.chat_session_type import ChatSessionType

class ChatSessionGetWithChatData(BaseModel):
    """
    ChatSessionGetWithChatData
    """
    id: StrictInt = Field(...)
    chat_id: StrictInt = Field(...)
    creator_id: StrictInt = Field(...)
    credentials: Dict[str, Any] = Field(...)
    chat_session_type: ChatSessionType = Field(...)
    created_at: StrictInt = Field(...)
    ended_at: Optional[StrictInt] = None
    messages: Optional[conlist(ChatMessageRead)] = None
    chat: ChatGetWithMembers = Field(...)
    tokens_used: Optional[Union[StrictFloat, StrictInt]] = 0.0
    __properties = ["id", "chat_id", "creator_id", "credentials", "chat_session_type", "created_at", "ended_at", "messages", "chat", "tokens_used"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatSessionGetWithChatData:
        """Create an instance of ChatSessionGetWithChatData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of chat
        if self.chat:
            _dict['chat'] = self.chat.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatSessionGetWithChatData:
        """Create an instance of ChatSessionGetWithChatData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatSessionGetWithChatData.parse_obj(obj)

        _obj = ChatSessionGetWithChatData.parse_obj({
            "id": obj.get("id"),
            "chat_id": obj.get("chat_id"),
            "creator_id": obj.get("creator_id"),
            "credentials": obj.get("credentials"),
            "chat_session_type": obj.get("chat_session_type"),
            "created_at": obj.get("created_at"),
            "ended_at": obj.get("ended_at"),
            "messages": [ChatMessageRead.from_dict(_item) for _item in obj.get("messages")] if obj.get("messages") is not None else None,
            "chat": ChatGetWithMembers.from_dict(obj.get("chat")) if obj.get("chat") is not None else None,
            "tokens_used": obj.get("tokens_used") if obj.get("tokens_used") is not None else 0.0
        })
        return _obj


