# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from landing_page_server_connector.models.course_submodule import CourseSubmodule

class ResponseWrapperListCourseSubmodule(BaseModel):
    """
    ResponseWrapperListCourseSubmodule
    """
    done: StrictBool = Field(default=..., description="Indicates if the operation was successful. True if successful, False otherwise. Always matches the HTTP status code. 2xx for success, 4xx or 5xx for failure.")
    result: Optional[conlist(CourseSubmodule)] = Field(default=None, description="The result of the operation, if successful. Should be a list of items of spcified model. If the operation failed, this will always be null.")
    error: Optional[StrictStr] = Field(default=None, description="Error message if the operation failed. Should be a string describing the error. If the operation was successful, this will always be null.")
    __properties = ["done", "result", "error"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResponseWrapperListCourseSubmodule:
        """Create an instance of ResponseWrapperListCourseSubmodule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in result (list)
        _items = []
        if self.result:
            for _item in self.result:
                if _item:
                    _items.append(_item.to_dict())
            _dict['result'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResponseWrapperListCourseSubmodule:
        """Create an instance of ResponseWrapperListCourseSubmodule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ResponseWrapperListCourseSubmodule.parse_obj(obj)

        _obj = ResponseWrapperListCourseSubmodule.parse_obj({
            "done": obj.get("done"),
            "result": [CourseSubmodule.from_dict(_item) for _item in obj.get("result")] if obj.get("result") is not None else None,
            "error": obj.get("error")
        })
        return _obj


