
#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>

import re

placeholder = '...'
escaped_placeholder = re.escape(placeholder)


def compare_string_with_pattern(pattern: str, string: str) -> bool:
    escaped_pattern = re.escape(pattern)
    regex_pattern = escaped_pattern.replace(escaped_placeholder, r'[^\n]*')
    # Проверяем соответствие всей строки шаблону
    return re.fullmatch(regex_pattern, string) is not None


def assert_string_match_pattern(pattern: str, string: str) -> None:
    pattern_lines, string_lines = pattern.splitlines(), string.splitlines()
    for pattern_line, string_line in zip(pattern_lines, string_lines):
        if not compare_string_with_pattern(pattern=pattern_line, string=string_line):
            raise ValueError(f"{pattern_line=!r} mismatch {string_line=!r}")
    if len(pattern_lines) != len(string_lines):
        raise ValueError(f"pattern has {len(pattern_lines)} lines != result lines: {len(string_lines)}")


def print_string_match_pattern(pattern: str, string: str, depth: int = 0) -> None:
    pattern_lines, string_lines = pattern.splitlines(), string.splitlines()
    for pattern_line, string_line in zip(pattern_lines, string_lines):
        print(' ' * depth + f'COMPARE  {pattern_line!r}  WITH  {string_line!r}... ', end='')
        print('MATCH' if compare_string_with_pattern(pattern=pattern_line, string=string_line) else 'FAIL')
    if (extra_pattern_lines := len(pattern_lines) - len(string_lines)) > 0:
        print(' ' * depth + f'PATTERN HAS {extra_pattern_lines} MORE LINES')
    if (extra_result_lines := len(string_lines) - len(pattern_lines)) > 0:
        print(' ' * depth + f'RESULT HAS {extra_result_lines} MORE LINES')
