#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import asyncio
import sys
import traceback

from run_markdown import get_logic_block_from_md_file


async def main():
    assert len(sys.argv) > 1
    target_file = sys.argv[1]
    block = get_logic_block_from_md_file(target_file)
    try:
        await block.evaluate()
    except Exception:
        print("CHECK FAILED")
        traceback.print_exc()
        exit(1)
    print("CHECK SUCCESS")


if __name__ == '__main__':
    asyncio.run(main())
