#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses
import typing
from typing import Protocol, runtime_checkable, Any


@runtime_checkable
@dataclasses.dataclass
class DataclassProtocol(Protocol):
    pass


@typing.overload
def assert_raise(condition: Any, exception: Exception) -> None: pass


@typing.overload
def assert_raise(condition: Any, exception: type[Exception], *args) -> None: pass


def assert_raise(condition: Any, exception: Exception | type[Exception], *args) -> None:
    if condition:
        if isinstance(exception, type) and args:
            exception = exception(*args)
        raise exception


def raise_if(condition: Any, exception: Exception | type[Exception], *args) -> None:
    if condition:
        if isinstance(exception, type) and args:
            exception = exception(*args)
        raise exception
