# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from ai_assistant_server_connector.models.module_lesson_public import ModuleLessonPublic

class CourseModulePublic(BaseModel):
    """
    CourseModulePublic
    """
    id: StrictInt = Field(...)
    title: StrictStr = Field(...)
    public_description: Optional[StrictStr] = None
    short_description: Optional[StrictStr] = None
    lessons: Optional[conlist(ModuleLessonPublic)] = None
    __properties = ["id", "title", "public_description", "short_description", "lessons"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CourseModulePublic:
        """Create an instance of CourseModulePublic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in lessons (list)
        _items = []
        if self.lessons:
            for _item in self.lessons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lessons'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CourseModulePublic:
        """Create an instance of CourseModulePublic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CourseModulePublic.parse_obj(obj)

        _obj = CourseModulePublic.parse_obj({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "public_description": obj.get("public_description"),
            "short_description": obj.get("short_description"),
            "lessons": [ModuleLessonPublic.from_dict(_item) for _item in obj.get("lessons")] if obj.get("lessons") is not None else None
        })
        return _obj


