#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>, Alexander Medvedev <a.medvedev@abm-jsc.ru>

from abc import ABC, abstractmethod
from typing import ClassVar


class AbstractThumbnailProcessor(ABC):
    processable_extensions: ClassVar[set[str]]

    @abstractmethod
    def process(self, content: bytes) -> bytes:
        pass

