# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from landing_page_server_connector.models.portal_language_enum import PortalLanguageEnum

class TemplateGet(BaseModel):
    """
    TemplateGet
    """
    html: StrictStr = Field(...)
    css: StrictStr = Field(...)
    js: StrictStr = Field(...)
    components: Dict[str, Any] = Field(...)
    styles: conlist(Dict[str, Any]) = Field(...)
    assets: conlist(Dict[str, Any]) = Field(...)
    name: StrictStr = Field(...)
    title: StrictStr = Field(...)
    path: StrictStr = Field(...)
    order: StrictInt = Field(...)
    language_id: PortalLanguageEnum = Field(...)
    staging_html: StrictStr = Field(...)
    staging_js: StrictStr = Field(...)
    staging_css: StrictStr = Field(...)
    staging_components: Dict[str, Any] = Field(...)
    staging_styles: conlist(Dict[str, Any]) = Field(...)
    staging_assets: conlist(Dict[str, Any]) = Field(...)
    id: StrictInt = Field(...)
    is_listed: StrictBool = Field(...)
    preview_id: Optional[StrictStr] = None
    created_at: StrictInt = Field(...)
    updated_at: Optional[StrictInt] = None
    published_at: Optional[StrictInt] = None
    deleted_at: Optional[StrictInt] = None
    __properties = ["html", "css", "js", "components", "styles", "assets", "name", "title", "path", "order", "language_id", "staging_html", "staging_js", "staging_css", "staging_components", "staging_styles", "staging_assets", "id", "is_listed", "preview_id", "created_at", "updated_at", "published_at", "deleted_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TemplateGet:
        """Create an instance of TemplateGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TemplateGet:
        """Create an instance of TemplateGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TemplateGet.parse_obj(obj)

        _obj = TemplateGet.parse_obj({
            "html": obj.get("html"),
            "css": obj.get("css"),
            "js": obj.get("js"),
            "components": obj.get("components"),
            "styles": obj.get("styles"),
            "assets": obj.get("assets"),
            "name": obj.get("name"),
            "title": obj.get("title"),
            "path": obj.get("path"),
            "order": obj.get("order"),
            "language_id": obj.get("language_id"),
            "staging_html": obj.get("staging_html"),
            "staging_js": obj.get("staging_js"),
            "staging_css": obj.get("staging_css"),
            "staging_components": obj.get("staging_components"),
            "staging_styles": obj.get("staging_styles"),
            "staging_assets": obj.get("staging_assets"),
            "id": obj.get("id"),
            "is_listed": obj.get("is_listed"),
            "preview_id": obj.get("preview_id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "published_at": obj.get("published_at"),
            "deleted_at": obj.get("deleted_at")
        })
        return _obj


