#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

class FileStorageException(Exception):
    pass


class FileAlreadyExists(FileStorageException):
    pass


class PathDoesNotExists(FileStorageException):
    pass


class InsecurePath(FileStorageException):
    pass


class S3InterfaceExceptions(Exception):
    pass


class BucketDoesNotExist(S3InterfaceExceptions):
    pass


class BucketAlreadyExist(S3InterfaceExceptions):
    pass
