# openai-connector
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.1.3+2121421598
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openai_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openai_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import openai_connector
from openai_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openai_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with openai_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openai_connector.OpenaiApi(api_client)
    prompt_bundle_for_generate_image = openai_connector.PromptBundleForGenerateImage() # PromptBundleForGenerateImage | 

    try:
        # Generate image
        api_response = await api_instance.generate_image_v1_openai_image_generate_post(prompt_bundle_for_generate_image)
        print("The response of OpenaiApi->generate_image_v1_openai_image_generate_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling OpenaiApi->generate_image_v1_openai_image_generate_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OpenaiApi* | [**generate_image_v1_openai_image_generate_post**](docs/OpenaiApi.md#generate_image_v1_openai_image_generate_post) | **POST** /v1/openai/image/generate | Generate image
*OpenaiApi* | [**generate_response_v1_openai_response_generate_post**](docs/OpenaiApi.md#generate_response_v1_openai_response_generate_post) | **POST** /v1/openai/response/generate | Generate response
*OpenaiApi* | [**stream_response_v1_openai_response_stream_post**](docs/OpenaiApi.md#stream_response_v1_openai_response_stream_post) | **POST** /v1/openai/response/stream | Stream response
*OpenaiConnectorApi* | [**generate_image_v1_openai_image_generate_post**](docs/OpenaiConnectorApi.md#generate_image_v1_openai_image_generate_post) | **POST** /v1/openai/image/generate | Generate image
*OpenaiConnectorApi* | [**generate_response_v1_openai_response_generate_post**](docs/OpenaiConnectorApi.md#generate_response_v1_openai_response_generate_post) | **POST** /v1/openai/response/generate | Generate response
*OpenaiConnectorApi* | [**stream_response_v1_openai_response_stream_post**](docs/OpenaiConnectorApi.md#stream_response_v1_openai_response_stream_post) | **POST** /v1/openai/response/stream | Stream response


## Documentation For Models

 - [ChatHistoryChatContent](docs/ChatHistoryChatContent.md)
 - [ChatHistoryItem](docs/ChatHistoryItem.md)
 - [ChatRole](docs/ChatRole.md)
 - [FilePayload](docs/FilePayload.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ImageResponse](docs/ImageResponse.md)
 - [ImageSettings](docs/ImageSettings.md)
 - [InputTokensDetails](docs/InputTokensDetails.md)
 - [OutputTokensDetails](docs/OutputTokensDetails.md)
 - [PromptBundle](docs/PromptBundle.md)
 - [PromptBundleForGenerateImage](docs/PromptBundleForGenerateImage.md)
 - [ResponseChunk](docs/ResponseChunk.md)
 - [ResponseChunkType](docs/ResponseChunkType.md)
 - [ResponseSchemaPayload](docs/ResponseSchemaPayload.md)
 - [ResponseUsage](docs/ResponseUsage.md)
 - [TextResponse](docs/TextResponse.md)
 - [Usage](docs/Usage.md)
 - [UsageInputTokensDetails](docs/UsageInputTokensDetails.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [WrappedResponseImageResponse](docs/WrappedResponseImageResponse.md)
 - [WrappedResponseTextResponse](docs/WrappedResponseTextResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




