#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass
from typing import Any

from .abstract import Token


@dataclass
class Literal(Token):
    body: dict[str, Token] | list[Token] | str | float | int | bool | None

    def eval(self, key_to_binding: dict[str, Any]) -> Any:
        return self._eval(self.body, key_to_binding)

    def _eval(self, target, key_to_binding: dict[str, Any]) -> Any:
        if isinstance(target, dict):
            return {key: self._eval(val, key_to_binding) for key, val in target.items()}
        if isinstance(target, list):
            return [self._eval(val, key_to_binding) for val in target]
        if isinstance(target, Token):
            return target.eval(key_to_binding)
        return target

    def get_root(self) -> Token:
        return self
