# QPEL(Query parameter expression language)
_This package contains only qpelparser (tool capable of parsing qpel-formatted string as qpel.Token tree). No qpel formatter included_   
**QPEL is simple context based language, it has only 3 element types:**
- **Getter** - get value by key in dict or an attribute of an object 
- **Call** - call target
- **Literal** - literal `list`/`str`/`float`/`int`  

### Getter
Non quoted string is a **Getter**. **EXAMPLES**:  
- `qqq` - get value by key "qqq" or attribute by name "qqq" from context.  
Equivalent of `context["qqq"] if isinstance(context, dict) else getattr(context, "qqq")`
- `QpelParser().parse("qqq").eval({'qqq': 42}))` - returns `42`

**Getter** elements can be chained with dot, **EXAMPLES**:  
- `qqq.www` - get value by key "qqq" or attribute by name "qqq" from context and from that value get by "www".   
Equivalent of 
```
val = context["qqq"] if isinstance(context, dict) else getattr(context, "qqq")
val["qqq"] if isinstance(val, dict) else getattr(val, "qqq")
```
- `QpelParser().parse("qqq.bit_length").eval({'qqq': 42}))` - 
returns `<built-in method bit_length of int object>`
- `QpelParser().parse("qqq.www").eval({'qqq': {'www': 42}}))` - returns `42`

### Call
Pair or round brackets is a **Call**. **EXAMPLES**:
- `qqq()` - get by "qqq" from context and call it without arguments/    
Equivalent of `(context["qqq"] if isinstance(context, dict) else getattr(context, "qqq"))()`
- `QpelParser().parse("bit_length()").eval(42))` - returns 6 (bit representation of 42: '101010', 6 bits)

Everything inside round brackets is parsed as distinct qpel strings, 
separated by commas and used as arguments. **EXAMPLES**:
- `a(b, c)` - get "a" from context and call it with "b" and "c" from the context
- `QpelParser().parse("a(b,c)").eval({'a':int,'b':'11','c':2}))` - equivalent of `int("11", 2)`, returns 3 (int accepts string with base)

Key arguments are also accepted. **EXAMPLE**:
- `QpelParser().parse("dict(qqq=a,www=b)").eval({'dict': dict, 'a': 1, 'b': 2})` - returns `{'qqq': 1, 'www': 2}`

### Literal
All other values are literals. **EXAMPLES**:
- `42` - int value 42
- `36.6` - float value 36.6
- `'qqq'` - string value 'qqq', **WARNING: only** single quotes are accepted
- `[]` - empty list  

Boolean values should present in context(implemented by Getter):
- `QpelParser().parse("True").eval({"True": True})` - returns boolean True  

**Dictionaries are not supported**. Could be changed later
