# chat-server-connector
Mentortools service for chatting

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.2.0+2303650742
- Generator version: 7.19.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import chat_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import chat_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import chat_server_connector
from chat_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = chat_server_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'

# Configure Bearer authorization: HTTPBearer
configuration = chat_server_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with chat_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = chat_server_connector.AdminApi(api_client)

    try:
        # Wipe Bots From Cache
        api_response = await api_instance.chat_api_wipe_bots_from_cache()
        print("The response of AdminApi->chat_api_wipe_bots_from_cache:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdminApi->chat_api_wipe_bots_from_cache: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**chat_api_wipe_bots_from_cache**](docs/AdminApi.md#chat_api_wipe_bots_from_cache) | **DELETE** /admin/v1/bot/cache | Wipe Bots From Cache
*AdminApi* | [**chat_api_wipe_portal_community_settings_from_cache**](docs/AdminApi.md#chat_api_wipe_portal_community_settings_from_cache) | **DELETE** /admin/v1/portal_community_settings/cache | Wipe Portal Community Settings From Cache
*AdminApi* | [**chat_api_wipe_portal_members_from_cache**](docs/AdminApi.md#chat_api_wipe_portal_members_from_cache) | **DELETE** /admin/v1/portal_member/cache | Wipe Portal Members From Cache
*BotsApi* | [**chat_api_bot_chat_chat_get**](docs/BotsApi.md#chat_api_bot_chat_chat_get) | **GET** /bots/v1/{bot_id}/chat | Bot Chat Chat Get
*BotsApi* | [**chat_api_bot_chat_get_or_create**](docs/BotsApi.md#chat_api_bot_chat_get_or_create) | **PUT** /bots/v1/{bot_id}/chat | Bot Chat Get Or Create
*BotsApi* | [**chat_api_bot_portal_chat_get**](docs/BotsApi.md#chat_api_bot_portal_chat_get) | **GET** /bots/v1/primary/chat | Bot Portal Chat Get
*BotsApi* | [**chat_api_bot_portal_chat_get_or_create**](docs/BotsApi.md#chat_api_bot_portal_chat_get_or_create) | **PUT** /bots/v1/primary/chat | Bot Portal Chat Get Or Create
*BotsApi* | [**chat_api_bot_shared_chat_get**](docs/BotsApi.md#chat_api_bot_shared_chat_get) | **GET** /bots/v1/shared/primary/chat | Bot Shared Chat Get
*BotsApi* | [**chat_api_bot_shared_chat_get_or_create**](docs/BotsApi.md#chat_api_bot_shared_chat_get_or_create) | **PUT** /bots/v1/shared/primary/chat | Bot Shared Chat Get Or Create
*ChatApiApi* | [**chat_api_bot_chat_chat_get**](docs/ChatApiApi.md#chat_api_bot_chat_chat_get) | **GET** /bots/v1/{bot_id}/chat | Bot Chat Chat Get
*ChatApiApi* | [**chat_api_bot_chat_get_or_create**](docs/ChatApiApi.md#chat_api_bot_chat_get_or_create) | **PUT** /bots/v1/{bot_id}/chat | Bot Chat Get Or Create
*ChatApiApi* | [**chat_api_bot_portal_chat_get**](docs/ChatApiApi.md#chat_api_bot_portal_chat_get) | **GET** /bots/v1/primary/chat | Bot Portal Chat Get
*ChatApiApi* | [**chat_api_bot_portal_chat_get_or_create**](docs/ChatApiApi.md#chat_api_bot_portal_chat_get_or_create) | **PUT** /bots/v1/primary/chat | Bot Portal Chat Get Or Create
*ChatApiApi* | [**chat_api_bot_shared_chat_get**](docs/ChatApiApi.md#chat_api_bot_shared_chat_get) | **GET** /bots/v1/shared/primary/chat | Bot Shared Chat Get
*ChatApiApi* | [**chat_api_bot_shared_chat_get_or_create**](docs/ChatApiApi.md#chat_api_bot_shared_chat_get_or_create) | **PUT** /bots/v1/shared/primary/chat | Bot Shared Chat Get Or Create
*ChatApiApi* | [**chat_api_chat_ai_usage_insert**](docs/ChatApiApi.md#chat_api_chat_ai_usage_insert) | **POST** /chats/v1/{chat_id}/ai_usage/insert | Chat Ai Usage Insert
*ChatApiApi* | [**chat_api_chat_delete**](docs/ChatApiApi.md#chat_api_chat_delete) | **DELETE** /chats/v1/{chat_id} | Chat Delete
*ChatApiApi* | [**chat_api_chat_get**](docs/ChatApiApi.md#chat_api_chat_get) | **GET** /chats/v1/{chat_id} | Chat Get
*ChatApiApi* | [**chat_api_chat_join**](docs/ChatApiApi.md#chat_api_chat_join) | **POST** /chats/v1/{chat_id}/join | Chat Join
*ChatApiApi* | [**chat_api_chat_leave**](docs/ChatApiApi.md#chat_api_chat_leave) | **POST** /chats/v1/{chat_id}/leave | Chat Leave
*ChatApiApi* | [**chat_api_chat_mark_as_read**](docs/ChatApiApi.md#chat_api_chat_mark_as_read) | **POST** /chats/v1/{chat_id}/mark_as_read | Chat Mark As Read
*ChatApiApi* | [**chat_api_chat_member_ban**](docs/ChatApiApi.md#chat_api_chat_member_ban) | **POST** /chats/v1/{chat_id}/members/{user_id}/ban | Chat Member Ban
*ChatApiApi* | [**chat_api_chat_members_list**](docs/ChatApiApi.md#chat_api_chat_members_list) | **GET** /chats/v1/{chat_id}/members | Chat Members List
*ChatApiApi* | [**chat_api_chat_members_update**](docs/ChatApiApi.md#chat_api_chat_members_update) | **PATCH** /chats/v1/{chat_id}/members | Chat Members Update
*ChatApiApi* | [**chat_api_chat_message_delete**](docs/ChatApiApi.md#chat_api_chat_message_delete) | **DELETE** /chats/v1/{chat_id}/messages/{message_id} | Chat Message Delete
*ChatApiApi* | [**chat_api_chat_message_get**](docs/ChatApiApi.md#chat_api_chat_message_get) | **GET** /chats/v1/{chat_id}/messages/{message_id} | Chat Message Get
*ChatApiApi* | [**chat_api_chat_messages_add**](docs/ChatApiApi.md#chat_api_chat_messages_add) | **POST** /chats/v1/{chat_id}/messages | Chat Messages Add
*ChatApiApi* | [**chat_api_chat_messages_insert**](docs/ChatApiApi.md#chat_api_chat_messages_insert) | **POST** /chats/v1/{chat_id}/messages/insert | Chat Messages Insert
*ChatApiApi* | [**chat_api_chat_messages_list**](docs/ChatApiApi.md#chat_api_chat_messages_list) | **GET** /chats/v1/{chat_id}/messages | Chat Messages List
*ChatApiApi* | [**chat_api_chat_mute**](docs/ChatApiApi.md#chat_api_chat_mute) | **POST** /chats/v1/{chat_id}/mute | Chat Mute
*ChatApiApi* | [**chat_api_chat_private_join**](docs/ChatApiApi.md#chat_api_chat_private_join) | **POST** /chats/v1/private/{chat_uuid}/join | Chat Private Join
*ChatApiApi* | [**chat_api_chat_session_get**](docs/ChatApiApi.md#chat_api_chat_session_get) | **GET** /chat_sessions/v1/{chat_session_id} | Chat Session Get
*ChatApiApi* | [**chat_api_chat_session_list_portal**](docs/ChatApiApi.md#chat_api_chat_session_list_portal) | **GET** /chat_sessions/v1/portal | Chat Session List Portal
*ChatApiApi* | [**chat_api_chat_session_portal_count**](docs/ChatApiApi.md#chat_api_chat_session_portal_count) | **GET** /chat_sessions/v1/portal/count | Chat Session Portal Count
*ChatApiApi* | [**chat_api_chat_session_start**](docs/ChatApiApi.md#chat_api_chat_session_start) | **POST** /chats/v1/{chat_id}/session/start | Chat Session Start
*ChatApiApi* | [**chat_api_chat_session_stop**](docs/ChatApiApi.md#chat_api_chat_session_stop) | **POST** /chats/v1/session/stop/{session_id} | Chat Session Stop
*ChatApiApi* | [**chat_api_chat_unmute**](docs/ChatApiApi.md#chat_api_chat_unmute) | **POST** /chats/v1/{chat_id}/unmute | Chat Unmute
*ChatApiApi* | [**chat_api_chat_update**](docs/ChatApiApi.md#chat_api_chat_update) | **PUT** /chats/v1/{chat_id} | Chat Update
*ChatApiApi* | [**chat_api_chats_add**](docs/ChatApiApi.md#chat_api_chats_add) | **POST** /chats/v1/ | Chats Add
*ChatApiApi* | [**chat_api_chats_list**](docs/ChatApiApi.md#chat_api_chats_list) | **GET** /chats/v1/ | Chats List
*ChatApiApi* | [**chat_api_chats_list_available**](docs/ChatApiApi.md#chat_api_chats_list_available) | **GET** /chats/v1/available | Chats List Available
*ChatApiApi* | [**chat_api_contact_chat_get**](docs/ChatApiApi.md#chat_api_contact_chat_get) | **GET** /contacts/v1/{user_id}/chat | Contact Chat Get
*ChatApiApi* | [**chat_api_contact_chat_get_or_create**](docs/ChatApiApi.md#chat_api_contact_chat_get_or_create) | **PUT** /contacts/v1/{user_id}/chat | Contact Chat Get Or Create
*ChatApiApi* | [**chat_api_contact_get**](docs/ChatApiApi.md#chat_api_contact_get) | **GET** /contacts/v1/{user_id} | Contact Get
*ChatApiApi* | [**chat_api_contacts_list**](docs/ChatApiApi.md#chat_api_contacts_list) | **GET** /contacts/v1/ | Contacts List
*ChatApiApi* | [**chat_api_get_total_unread_messages**](docs/ChatApiApi.md#chat_api_get_total_unread_messages) | **GET** /chats/v1/unread/count | Get Total Unread Messages
*ChatApiApi* | [**chat_api_settings_get**](docs/ChatApiApi.md#chat_api_settings_get) | **GET** /settings/v1/ | Settings Get
*ChatApiApi* | [**chat_api_settings_set**](docs/ChatApiApi.md#chat_api_settings_set) | **PUT** /settings/v1/ | Settings Set
*ChatApiApi* | [**chat_api_wipe_bots_from_cache**](docs/ChatApiApi.md#chat_api_wipe_bots_from_cache) | **DELETE** /admin/v1/bot/cache | Wipe Bots From Cache
*ChatApiApi* | [**chat_api_wipe_portal_community_settings_from_cache**](docs/ChatApiApi.md#chat_api_wipe_portal_community_settings_from_cache) | **DELETE** /admin/v1/portal_community_settings/cache | Wipe Portal Community Settings From Cache
*ChatApiApi* | [**chat_api_wipe_portal_members_from_cache**](docs/ChatApiApi.md#chat_api_wipe_portal_members_from_cache) | **DELETE** /admin/v1/portal_member/cache | Wipe Portal Members From Cache
*ChatSessionsApi* | [**chat_api_chat_session_get**](docs/ChatSessionsApi.md#chat_api_chat_session_get) | **GET** /chat_sessions/v1/{chat_session_id} | Chat Session Get
*ChatSessionsApi* | [**chat_api_chat_session_list_portal**](docs/ChatSessionsApi.md#chat_api_chat_session_list_portal) | **GET** /chat_sessions/v1/portal | Chat Session List Portal
*ChatSessionsApi* | [**chat_api_chat_session_portal_count**](docs/ChatSessionsApi.md#chat_api_chat_session_portal_count) | **GET** /chat_sessions/v1/portal/count | Chat Session Portal Count
*ChatSettingsApi* | [**chat_api_settings_get**](docs/ChatSettingsApi.md#chat_api_settings_get) | **GET** /settings/v1/ | Settings Get
*ChatSettingsApi* | [**chat_api_settings_set**](docs/ChatSettingsApi.md#chat_api_settings_set) | **PUT** /settings/v1/ | Settings Set
*ChatsApi* | [**chat_api_chat_ai_usage_insert**](docs/ChatsApi.md#chat_api_chat_ai_usage_insert) | **POST** /chats/v1/{chat_id}/ai_usage/insert | Chat Ai Usage Insert
*ChatsApi* | [**chat_api_chat_delete**](docs/ChatsApi.md#chat_api_chat_delete) | **DELETE** /chats/v1/{chat_id} | Chat Delete
*ChatsApi* | [**chat_api_chat_get**](docs/ChatsApi.md#chat_api_chat_get) | **GET** /chats/v1/{chat_id} | Chat Get
*ChatsApi* | [**chat_api_chat_join**](docs/ChatsApi.md#chat_api_chat_join) | **POST** /chats/v1/{chat_id}/join | Chat Join
*ChatsApi* | [**chat_api_chat_leave**](docs/ChatsApi.md#chat_api_chat_leave) | **POST** /chats/v1/{chat_id}/leave | Chat Leave
*ChatsApi* | [**chat_api_chat_mark_as_read**](docs/ChatsApi.md#chat_api_chat_mark_as_read) | **POST** /chats/v1/{chat_id}/mark_as_read | Chat Mark As Read
*ChatsApi* | [**chat_api_chat_member_ban**](docs/ChatsApi.md#chat_api_chat_member_ban) | **POST** /chats/v1/{chat_id}/members/{user_id}/ban | Chat Member Ban
*ChatsApi* | [**chat_api_chat_members_list**](docs/ChatsApi.md#chat_api_chat_members_list) | **GET** /chats/v1/{chat_id}/members | Chat Members List
*ChatsApi* | [**chat_api_chat_members_update**](docs/ChatsApi.md#chat_api_chat_members_update) | **PATCH** /chats/v1/{chat_id}/members | Chat Members Update
*ChatsApi* | [**chat_api_chat_message_delete**](docs/ChatsApi.md#chat_api_chat_message_delete) | **DELETE** /chats/v1/{chat_id}/messages/{message_id} | Chat Message Delete
*ChatsApi* | [**chat_api_chat_message_get**](docs/ChatsApi.md#chat_api_chat_message_get) | **GET** /chats/v1/{chat_id}/messages/{message_id} | Chat Message Get
*ChatsApi* | [**chat_api_chat_messages_add**](docs/ChatsApi.md#chat_api_chat_messages_add) | **POST** /chats/v1/{chat_id}/messages | Chat Messages Add
*ChatsApi* | [**chat_api_chat_messages_insert**](docs/ChatsApi.md#chat_api_chat_messages_insert) | **POST** /chats/v1/{chat_id}/messages/insert | Chat Messages Insert
*ChatsApi* | [**chat_api_chat_messages_list**](docs/ChatsApi.md#chat_api_chat_messages_list) | **GET** /chats/v1/{chat_id}/messages | Chat Messages List
*ChatsApi* | [**chat_api_chat_mute**](docs/ChatsApi.md#chat_api_chat_mute) | **POST** /chats/v1/{chat_id}/mute | Chat Mute
*ChatsApi* | [**chat_api_chat_private_join**](docs/ChatsApi.md#chat_api_chat_private_join) | **POST** /chats/v1/private/{chat_uuid}/join | Chat Private Join
*ChatsApi* | [**chat_api_chat_session_start**](docs/ChatsApi.md#chat_api_chat_session_start) | **POST** /chats/v1/{chat_id}/session/start | Chat Session Start
*ChatsApi* | [**chat_api_chat_session_stop**](docs/ChatsApi.md#chat_api_chat_session_stop) | **POST** /chats/v1/session/stop/{session_id} | Chat Session Stop
*ChatsApi* | [**chat_api_chat_unmute**](docs/ChatsApi.md#chat_api_chat_unmute) | **POST** /chats/v1/{chat_id}/unmute | Chat Unmute
*ChatsApi* | [**chat_api_chat_update**](docs/ChatsApi.md#chat_api_chat_update) | **PUT** /chats/v1/{chat_id} | Chat Update
*ChatsApi* | [**chat_api_chats_add**](docs/ChatsApi.md#chat_api_chats_add) | **POST** /chats/v1/ | Chats Add
*ChatsApi* | [**chat_api_chats_list**](docs/ChatsApi.md#chat_api_chats_list) | **GET** /chats/v1/ | Chats List
*ChatsApi* | [**chat_api_chats_list_available**](docs/ChatsApi.md#chat_api_chats_list_available) | **GET** /chats/v1/available | Chats List Available
*ChatsApi* | [**chat_api_get_total_unread_messages**](docs/ChatsApi.md#chat_api_get_total_unread_messages) | **GET** /chats/v1/unread/count | Get Total Unread Messages
*ContactsApi* | [**chat_api_contact_chat_get**](docs/ContactsApi.md#chat_api_contact_chat_get) | **GET** /contacts/v1/{user_id}/chat | Contact Chat Get
*ContactsApi* | [**chat_api_contact_chat_get_or_create**](docs/ContactsApi.md#chat_api_contact_chat_get_or_create) | **PUT** /contacts/v1/{user_id}/chat | Contact Chat Get Or Create
*ContactsApi* | [**chat_api_contact_get**](docs/ContactsApi.md#chat_api_contact_get) | **GET** /contacts/v1/{user_id} | Contact Get
*ContactsApi* | [**chat_api_contacts_list**](docs/ContactsApi.md#chat_api_contacts_list) | **GET** /contacts/v1/ | Contacts List
*DefaultApi* | [**default_health_check**](docs/DefaultApi.md#default_health_check) | **GET** / | Health Check


## Documentation For Models

 - [AiAssistantGet](docs/AiAssistantGet.md)
 - [AiAssistantGoalGet](docs/AiAssistantGoalGet.md)
 - [AssistantFunction](docs/AssistantFunction.md)
 - [ChatGetWithMembers](docs/ChatGetWithMembers.md)
 - [ChatGetWithMembersAndMessages](docs/ChatGetWithMembersAndMessages.md)
 - [ChatListGet](docs/ChatListGet.md)
 - [ChatMemberCreateOrUpdate](docs/ChatMemberCreateOrUpdate.md)
 - [ChatMemberGet](docs/ChatMemberGet.md)
 - [ChatMemberRole](docs/ChatMemberRole.md)
 - [ChatMemberRoleAdd](docs/ChatMemberRoleAdd.md)
 - [ChatMessage](docs/ChatMessage.md)
 - [ChatMessageCreate](docs/ChatMessageCreate.md)
 - [ChatMessageInsert](docs/ChatMessageInsert.md)
 - [ChatMessageRead](docs/ChatMessageRead.md)
 - [ChatMessageType](docs/ChatMessageType.md)
 - [ChatNew](docs/ChatNew.md)
 - [ChatSessionGet](docs/ChatSessionGet.md)
 - [ChatSessionGetWithChatData](docs/ChatSessionGetWithChatData.md)
 - [ChatSessionType](docs/ChatSessionType.md)
 - [ChatSettingsCreateOrUpdate](docs/ChatSettingsCreateOrUpdate.md)
 - [ChatSettingsGet](docs/ChatSettingsGet.md)
 - [ChatType](docs/ChatType.md)
 - [ChatUpdate](docs/ChatUpdate.md)
 - [ConsumedUnits](docs/ConsumedUnits.md)
 - [Contact](docs/Contact.md)
 - [ContactAddress](docs/ContactAddress.md)
 - [ConversationStyle](docs/ConversationStyle.md)
 - [CourseModulePublic](docs/CourseModulePublic.md)
 - [CoursePaymentTypeStrEnum](docs/CoursePaymentTypeStrEnum.md)
 - [CoursePublic](docs/CoursePublic.md)
 - [GoalEngagementPresetGet](docs/GoalEngagementPresetGet.md)
 - [GoalInteractionsSummary](docs/GoalInteractionsSummary.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [LocationInner](docs/LocationInner.md)
 - [ModuleLessonPublic](docs/ModuleLessonPublic.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperChatGetWithMembersAndMessages](docs/ResponseWrapperChatGetWithMembersAndMessages.md)
 - [ResponseWrapperChatMessage](docs/ResponseWrapperChatMessage.md)
 - [ResponseWrapperChatSessionGet](docs/ResponseWrapperChatSessionGet.md)
 - [ResponseWrapperChatSessionGetWithChatData](docs/ResponseWrapperChatSessionGetWithChatData.md)
 - [ResponseWrapperChatSettingsGet](docs/ResponseWrapperChatSettingsGet.md)
 - [ResponseWrapperContact](docs/ResponseWrapperContact.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperListChatListGet](docs/ResponseWrapperListChatListGet.md)
 - [ResponseWrapperListChatMemberGet](docs/ResponseWrapperListChatMemberGet.md)
 - [ResponseWrapperListChatMessageRead](docs/ResponseWrapperListChatMessageRead.md)
 - [ResponseWrapperListChatSessionGetWithChatData](docs/ResponseWrapperListChatSessionGetWithChatData.md)
 - [ResponseWrapperListContact](docs/ResponseWrapperListContact.md)
 - [Result](docs/Result.md)
 - [RoleEnum](docs/RoleEnum.md)
 - [UsageDataFromFront](docs/UsageDataFromFront.md)
 - [ValidationError](docs/ValidationError.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: server_name
- **Location**: HTTP header


## Author




