#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import collections
import typing

T = typing.TypeVar('T', bound=typing.Any)


def to_list(x: T) -> list[T]:
    if isinstance(x, list):
        return x
    # noinspection PyUnresolvedReferences,PyProtectedMember
    if isinstance(x, collections.abc.Iterable) and not isinstance(x, str | bytes | typing._GenericAlias):
        return list(x)
    return [x]
