#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
import abc
from typing import Optional, Type

from clickhouse_tools.elements.clickhouse_types import ClickHouseType


class Selectable(abc.ABC):

    def __init__(self,
                 clickhouse_type: Type[ClickHouseType],
                 nullable: bool = False,
                 name: Optional[str] = None,
                 ):
        self.name: Optional[str] = name
        self.clickhouse_type: Type[ClickHouseType] = clickhouse_type
        self.nullable: bool = nullable

    def to_selector(self) -> str:
        return self.name

    def __str__(self):
        return self.name
