#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from dataclasses import dataclass

from .connector import FileServerConnector


class ServerNameFileServerConnector(FileServerConnector):

    @dataclass
    class SafeRegionConfig:
        server_name: str

    @dataclass
    class Config(FileServerConnector.Config, SafeRegionConfig):
        pass

    Context = FileServerConnector.Context

    def __init__(self, config: Config, context: Context) -> None:
        self._server_name = config.server_name
        super(ServerNameFileServerConnector, self).__init__(config, context)

    def _construct_headers(self) -> dict[str, str]:
        headers = super(ServerNameFileServerConnector, self)._construct_headers()
        headers["server_name"] = self._server_name
        return headers
