# gemini-connector
Mentortools service for conencting to Gemini API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.1.1+2088388860
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import gemini_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import gemini_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import gemini_connector
from gemini_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = gemini_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with gemini_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gemini_connector.DefaultApi(api_client)

    try:
        # Health Check
        api_response = await api_instance.default_health_check()
        print("The response of DefaultApi->default_health_check:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->default_health_check: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**default_health_check**](docs/DefaultApi.md#default_health_check) | **GET** / | Health Check
*GeminiApiApi* | [**gemini_api_generate_access_token**](docs/GeminiApiApi.md#gemini_api_generate_access_token) | **POST** /token/v1/generate | Generate Access Token
*TokenApi* | [**gemini_api_generate_access_token**](docs/TokenApi.md#gemini_api_generate_access_token) | **POST** /token/v1/generate | Generate Access Token


## Documentation For Models

 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperStr](docs/ResponseWrapperStr.md)
 - [Result](docs/Result.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




