#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>

import re

placeholder = '...'
escaped_placeholder = re.escape(placeholder)


def compare_string_with_pattern(pattern: str, string: str) -> bool:
    escaped_pattern = re.escape(pattern)
    regex_pattern = escaped_pattern.replace(escaped_placeholder, r'[^\n]*')
    # Проверяем соответствие всей строки шаблону
    return re.fullmatch(regex_pattern, string) is not None
