# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from pydantic import StrictInt, StrictStr, conlist

from typing import Optional

from chat_server_connector.models.response_wrapper_chat_session_get import ResponseWrapperChatSessionGet
from chat_server_connector.models.response_wrapper_int import ResponseWrapperInt
from chat_server_connector.models.response_wrapper_list_chat_list_get import ResponseWrapperListChatListGet

from chat_server_connector.api_client import ApiClient
from chat_server_connector.api_response import ApiResponse
from chat_server_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ChatSessionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def chat_api_chat_session_get(self, chat_session_id : StrictInt, **kwargs) -> ResponseWrapperChatSessionGet:  # noqa: E501
        """Chat Session Get  # noqa: E501


        :param chat_session_id: (required)
        :type chat_session_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperChatSessionGet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the chat_api_chat_session_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.chat_api_chat_session_get_with_http_info(chat_session_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def chat_api_chat_session_get_with_http_info(self, chat_session_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Chat Session Get  # noqa: E501


        :param chat_session_id: (required)
        :type chat_session_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperChatSessionGet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'chat_session_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chat_api_chat_session_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['chat_session_id'] is not None:
            _path_params['chat_session_id'] = _params['chat_session_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperChatSessionGet",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/chat_sessions/v1/{chat_session_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def chat_api_chat_session_list_portal(self, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, search : Optional[StrictStr] = None, ids : Optional[conlist(StrictInt)] = None, **kwargs) -> ResponseWrapperListChatListGet:  # noqa: E501
        """Chat Session List Portal  # noqa: E501


        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param search:
        :type search: str
        :param ids:
        :type ids: List[int]
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListChatListGet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the chat_api_chat_session_list_portal_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.chat_api_chat_session_list_portal_with_http_info(limit, offset, search, ids, **kwargs)  # noqa: E501

    @validate_arguments
    async def chat_api_chat_session_list_portal_with_http_info(self, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, search : Optional[StrictStr] = None, ids : Optional[conlist(StrictInt)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Chat Session List Portal  # noqa: E501


        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param search:
        :type search: str
        :param ids:
        :type ids: List[int]
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListChatListGet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'search',
            'ids'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chat_api_chat_session_list_portal" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))

        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
            _collection_formats['ids'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListChatListGet",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/chat_sessions/v1/portal', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def chat_api_chat_session_portal_count(self, search : Optional[StrictStr] = None, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Chat Session Portal Count  # noqa: E501


        :param search:
        :type search: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the chat_api_chat_session_portal_count_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.chat_api_chat_session_portal_count_with_http_info(search, **kwargs)  # noqa: E501

    @validate_arguments
    async def chat_api_chat_session_portal_count_with_http_info(self, search : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Chat Session Portal Count  # noqa: E501


        :param search:
        :type search: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'search'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chat_api_chat_session_portal_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/chat_sessions/v1/portal/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
