
## FileStorageHandler
Это набор компонентов для организации различной бизнес-логики, связанной с хранением файлов

### Основные понятия и компоненты:
#### AbstractFileStorage
Единый интерфейс для различных файловых хранилищ. Имеет две реализации: S3 и Disc.  
Описан в библиотеке file-storage-abm. Используется в качестве нижнего, "физического" уровня хранения.  
Удобно создавать из url с помощью get_file_storage
Грубо говоря, имеет интерфейс, как у словаря `dict[str, bytes]`

#### FileKeeper
Обёртка над AbstractFileStorage, расширяющая его интерфейс с помощью базы данных.  
Работает с файлами, скорее как с блоками данных - не использует имя, работает только с содержимым.  
Сохраняет информацию о сохранённых файлах в FileInfo или дочерний класс (указывается в `__init__`).  
upload идемпотентный, т.е. при повторной загрузке файла с содержимым, идентичным ранее сохранённому, ответ не меняется
Грубо говоря, имеет интерфейс, как у сета `set[bytes]`  

#### LinkKeeper
Обёртка над FileKeeper, сохраняющая файлы в виде именованных ссылок(LinkInfo) на содержимое (FileInfo).
Работает с файлами, как с файлами - сохраняет имена, знает про расширения. 
При удалении последней ссылки(LinkInfo) на файл(FileInfo) удаляет и файл(в том числе с хранилища)
Грубо говоря, имеет интерфейс, как у словаря `dict[str, bytes]`

#### ThumbnailProvider
Компонент, генерирующий thumbnail (небольшую картинку-превью) на основе расширения и содержимого файла

#### Controller
Компонент, реализующий бизнес логику с помощью вышеописанных компонентов:
- **upload**: Загружает исходный файл в LinkKeeper, если thumbnail нужен, то ищет готовый и создаёт ссылку на него или делает новый
- **get**: отдаёт исходный файл с LinkKeeper
- **get_thumbnail**: отдаёт thumbnail с LinkKeeper'а по id исходного файла
- **head**: отдаёт инфу о исходном файле с LinkKeeper
- **delete**: удаляет ссылку на файл и его thumbnail при наличии
- **zip_files**: формирует архив из файлов по id

#### HttpHandler
Предоставляет HTTP API для методов Controller'а

### Предполагаемые сценарии использования
#### Запуск в виде модуля
Через переменные среды или аргументы запуска передаются url файлового хранилища (`file_storage_url`) и базы (`db_url`), 
а так же адрес для обработки запросов (`listen`), пример:
```shell
python -m file_storage_handler --db_url='postgresql://<log>:<pass>@<addr>/<db>' --file_storage_url='file:///tmp/storage' --listen='0.0.0.0:80'
```

#### Специфическая бизнес логика или апи на базе существующих моделей
Примеры:
- добавить авторизацию в HTTP API
- сделать формирование нескольких preview разного разрешения 

В этом сценарии предполагается разработка отдельного Controller и/или HttpHandler, пример можно увидеть в entity_compatible_file_storage

#### Специфическая бизнес логика, требующая расширения модели данных
Примеры: 
- добавить ссылкам авторство и ограничения по используемому пространству
- добавить ссылкам срок жизни и удалять их по истечении срока жизни

В этом сценарии предполагается разработка расширенных моделей и передача их в конструкторы FileKeeper и LinkKeeper, 
а так же разработка отдельного Controller и/или HttpHandler. Примера пока нет (если уже есть, то впишите, пожалуйста)