# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from landing_page_server_connector.models.script_category import ScriptCategory
from landing_page_server_connector.models.script_element import ScriptElement
from landing_page_server_connector.models.script_placement import ScriptPlacement

class LandingScriptGet(BaseModel):
    """
    LandingScriptGet
    """
    elements: conlist(ScriptElement) = Field(...)
    title: StrictStr = Field(...)
    category: ScriptCategory = Field(...)
    placement: ScriptPlacement = Field(...)
    elements_str: Optional[StrictStr] = ''
    __properties = ["elements", "title", "category", "placement", "elements_str"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LandingScriptGet:
        """Create an instance of LandingScriptGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in elements (list)
        _items = []
        if self.elements:
            for _item in self.elements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['elements'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LandingScriptGet:
        """Create an instance of LandingScriptGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LandingScriptGet.parse_obj(obj)

        _obj = LandingScriptGet.parse_obj({
            "elements": [ScriptElement.from_dict(_item) for _item in obj.get("elements")] if obj.get("elements") is not None else None,
            "title": obj.get("title"),
            "category": obj.get("category"),
            "placement": obj.get("placement"),
            "elements_str": obj.get("elements_str") if obj.get("elements_str") is not None else ''
        })
        return _obj


