# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr, conlist
from landing_page_server_connector.models.portal_language_enum import PortalLanguageEnum

class TemplatePatch(BaseModel):
    """
    TemplatePatch
    """
    name: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    order: Optional[StrictInt] = None
    html: Optional[StrictStr] = None
    css: Optional[StrictStr] = None
    js: Optional[StrictStr] = None
    components: Optional[Dict[str, Any]] = None
    styles: Optional[conlist(Dict[str, Any])] = None
    assets: Optional[conlist(Dict[str, Any])] = None
    theme: Optional[Dict[str, Any]] = None
    language_id: Optional[PortalLanguageEnum] = None
    is_listed: Optional[StrictBool] = None
    staging_html: Optional[StrictStr] = None
    staging_css: Optional[StrictStr] = None
    staging_js: Optional[StrictStr] = None
    staging_components: Optional[Dict[str, Any]] = None
    staging_styles: Optional[conlist(Dict[str, Any])] = None
    staging_assets: Optional[conlist(Dict[str, Any])] = None
    staging_theme: Optional[Dict[str, Any]] = None
    __properties = ["name", "title", "order", "html", "css", "js", "components", "styles", "assets", "theme", "language_id", "is_listed", "staging_html", "staging_css", "staging_js", "staging_components", "staging_styles", "staging_assets", "staging_theme"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TemplatePatch:
        """Create an instance of TemplatePatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TemplatePatch:
        """Create an instance of TemplatePatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TemplatePatch.parse_obj(obj)

        _obj = TemplatePatch.parse_obj({
            "name": obj.get("name"),
            "title": obj.get("title"),
            "order": obj.get("order"),
            "html": obj.get("html"),
            "css": obj.get("css"),
            "js": obj.get("js"),
            "components": obj.get("components"),
            "styles": obj.get("styles"),
            "assets": obj.get("assets"),
            "theme": obj.get("theme"),
            "language_id": obj.get("language_id"),
            "is_listed": obj.get("is_listed"),
            "staging_html": obj.get("staging_html"),
            "staging_css": obj.get("staging_css"),
            "staging_js": obj.get("staging_js"),
            "staging_components": obj.get("staging_components"),
            "staging_styles": obj.get("staging_styles"),
            "staging_assets": obj.get("staging_assets"),
            "staging_theme": obj.get("staging_theme")
        })
        return _obj


