# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from landing_page_server_connector.models.course_access_type_str_enum import CourseAccessTypeStrEnum
from landing_page_server_connector.models.course_module_view_type_str_enum import CourseModuleViewTypeStrEnum
from landing_page_server_connector.models.course_payment_type_str_enum import CoursePaymentTypeStrEnum

class CoursePatch(BaseModel):
    """
    CoursePatch
    """
    order: Optional[StrictInt] = Field(default=None, description="Order of the course in the list. If not provided, it will not be updated.")
    title: Optional[StrictStr] = Field(default=None, description="Title of the course, if not provided, it will not be updated.")
    image_id: Optional[StrictStr] = Field(default=None, description="ID of the course image on file service, if not provided, it will not be updated.")
    description: Optional[StrictStr] = Field(default=None, description="Description of the course, if not provided, it will not be updated.")
    url: Optional[StrictStr] = Field(default=None, description="URL of the sales page, if landing page is not used, if not provided, it will not be updated.")
    payload: Optional[StrictStr] = Field(default=None, description="Info about the course, text or HTML content, if not provided, it will not be updated.")
    module_view_type: Optional[CourseModuleViewTypeStrEnum] = Field(default=None, description="Type of the course module view, if not provided, it will not be updated.")
    payment_type: Optional[CoursePaymentTypeStrEnum] = Field(default=None, description="Type of payment for the course, if not provided, it will not be updated.")
    course_access_type: Optional[CourseAccessTypeStrEnum] = Field(default=None, description="Type of access to the course, if not provided, it will not be updated.")
    number_days_access: Optional[StrictInt] = Field(default=None, description="Number of days access to the course, if not provided, it will not be updated.")
    is_active: Optional[StrictBool] = Field(default=None, description="Whether the course is active and available for users. If not provided, it will not be updated.")
    is_secret: Optional[StrictBool] = Field(default=None, description="Whether the course is secret and not listed publicly on dashboard, does not affect visibility in the mobile app. If not provided, it will not be updated.")
    is_archived: Optional[StrictBool] = Field(default=None, description="Whether the course is archived (deleted and to be removed from database). If not provided, it will not be updated.")
    is_displayed_in_app: Optional[StrictBool] = Field(default=None, description="Whether the course is displayed in mobile app, unrelated to the course visibility in the web app. If not provided, it will not be updated.")
    is_offline_downloadable: Optional[StrictBool] = Field(default=None, description="Whether the course can be downloaded for offline access in the mobile app. If not provided, it will not be updated.")
    available_at: Optional[StrictInt] = None
    launch_date_enabled: Optional[StrictBool] = None
    launch_date: Optional[StrictInt] = None
    __properties = ["order", "title", "image_id", "description", "url", "payload", "module_view_type", "payment_type", "course_access_type", "number_days_access", "is_active", "is_secret", "is_archived", "is_displayed_in_app", "is_offline_downloadable", "available_at", "launch_date_enabled", "launch_date"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CoursePatch:
        """Create an instance of CoursePatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CoursePatch:
        """Create an instance of CoursePatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CoursePatch.parse_obj(obj)

        _obj = CoursePatch.parse_obj({
            "order": obj.get("order"),
            "title": obj.get("title"),
            "image_id": obj.get("image_id"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "payload": obj.get("payload"),
            "module_view_type": obj.get("module_view_type"),
            "payment_type": obj.get("payment_type"),
            "course_access_type": obj.get("course_access_type"),
            "number_days_access": obj.get("number_days_access"),
            "is_active": obj.get("is_active"),
            "is_secret": obj.get("is_secret"),
            "is_archived": obj.get("is_archived"),
            "is_displayed_in_app": obj.get("is_displayed_in_app"),
            "is_offline_downloadable": obj.get("is_offline_downloadable"),
            "available_at": obj.get("available_at"),
            "launch_date_enabled": obj.get("launch_date_enabled"),
            "launch_date": obj.get("launch_date")
        })
        return _obj


