from dataclasses import dataclass

from .column import Column
from ..utils.escape import escape


@dataclass
class Order:
    column: Column
    ascending: bool

    def __str__(self):
        return f'{escape(self.column)} {"ASC" if self.ascending else "DESC"}'
