# landing-page-server-connector
Mentortools service for building and publishing landing pages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.1.0+1629514691
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import landing_page_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import landing_page_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import landing_page_server_connector
from landing_page_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = landing_page_server_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with landing_page_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = landing_page_server_connector.DefaultApi(api_client)

    try:
        # Health Check
        api_response = await api_instance.health_check_get()
        print("The response of DefaultApi->health_check_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->health_check_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**health_check_get**](docs/DefaultApi.md#health_check_get) | **GET** / | Health Check
*DefaultApi* | [**landing_form_add_v1_landings_landing_id_forms_post**](docs/DefaultApi.md#landing_form_add_v1_landings_landing_id_forms_post) | **POST** /v1/landings/{landing_id}/forms | Landing Form Add
*DefaultApi* | [**landing_form_count_v1_landings_landing_id_forms_count_get**](docs/DefaultApi.md#landing_form_count_v1_landings_landing_id_forms_count_get) | **GET** /v1/landings/{landing_id}/forms/count | Landing Form Count
*DefaultApi* | [**landing_form_delete_all_v1_landings_landing_id_forms_delete**](docs/DefaultApi.md#landing_form_delete_all_v1_landings_landing_id_forms_delete) | **DELETE** /v1/landings/{landing_id}/forms | Landing Form Delete All
*DefaultApi* | [**landing_form_delete_v1_landings_landing_id_forms_form_id_delete**](docs/DefaultApi.md#landing_form_delete_v1_landings_landing_id_forms_form_id_delete) | **DELETE** /v1/landings/{landing_id}/forms/{form_id} | Landing Form Delete
*DefaultApi* | [**landing_form_get_v1_landings_landing_id_forms_form_id_get**](docs/DefaultApi.md#landing_form_get_v1_landings_landing_id_forms_form_id_get) | **GET** /v1/landings/{landing_id}/forms/{form_id} | Landing Form Get
*DefaultApi* | [**landing_form_recover_v1_landings_landing_id_forms_form_id_recover_post**](docs/DefaultApi.md#landing_form_recover_v1_landings_landing_id_forms_form_id_recover_post) | **POST** /v1/landings/{landing_id}/forms/{form_id}/recover | Landing Form Recover
*DefaultApi* | [**landing_form_update_v1_landings_landing_id_forms_form_id_post**](docs/DefaultApi.md#landing_form_update_v1_landings_landing_id_forms_form_id_post) | **POST** /v1/landings/{landing_id}/forms/{form_id} | Landing Form Update
*DefaultApi* | [**landing_forms_list_v1_landings_landing_id_forms_get**](docs/DefaultApi.md#landing_forms_list_v1_landings_landing_id_forms_get) | **GET** /v1/landings/{landing_id}/forms | Landing Forms List
*DefaultApi* | [**landing_forms_patch_all_v1_landings_landing_id_forms_patch**](docs/DefaultApi.md#landing_forms_patch_all_v1_landings_landing_id_forms_patch) | **PATCH** /v1/landings/{landing_id}/forms | Landing Forms Patch All
*DefaultApi* | [**landing_forms_patch_v1_landings_landing_id_forms_form_id_patch**](docs/DefaultApi.md#landing_forms_patch_v1_landings_landing_id_forms_form_id_patch) | **PATCH** /v1/landings/{landing_id}/forms/{form_id} | Landing Forms Patch
*DefaultApi* | [**landing_history_count_v1_landings_landing_id_history_count_get**](docs/DefaultApi.md#landing_history_count_v1_landings_landing_id_history_count_get) | **GET** /v1/landings/{landing_id}/history/count | Landing History Count
*DefaultApi* | [**landing_history_get_v1_landings_landing_id_history_history_id_get**](docs/DefaultApi.md#landing_history_get_v1_landings_landing_id_history_history_id_get) | **GET** /v1/landings/{landing_id}/history/{history_id} | Landing History Get
*DefaultApi* | [**landing_history_list_v1_landings_landing_id_history_get**](docs/DefaultApi.md#landing_history_list_v1_landings_landing_id_history_get) | **GET** /v1/landings/{landing_id}/history | Landing History List
*DefaultApi* | [**landings_add_v1_landings_post**](docs/DefaultApi.md#landings_add_v1_landings_post) | **POST** /v1/landings/ | Landings Add
*DefaultApi* | [**landings_count_v1_landings_count_get**](docs/DefaultApi.md#landings_count_v1_landings_count_get) | **GET** /v1/landings/count | Landings Count
*DefaultApi* | [**landings_delete_v1_landings_landing_id_delete**](docs/DefaultApi.md#landings_delete_v1_landings_landing_id_delete) | **DELETE** /v1/landings/{landing_id} | Landings Delete
*DefaultApi* | [**landings_duplicate_v1_landings_landing_id_duplicate_post**](docs/DefaultApi.md#landings_duplicate_v1_landings_landing_id_duplicate_post) | **POST** /v1/landings/{landing_id}/duplicate | Landings Duplicate
*DefaultApi* | [**landings_get_v1_landings_landing_id_get**](docs/DefaultApi.md#landings_get_v1_landings_landing_id_get) | **GET** /v1/landings/{landing_id} | Landings Get
*DefaultApi* | [**landings_group_patch_v1_landings_patch**](docs/DefaultApi.md#landings_group_patch_v1_landings_patch) | **PATCH** /v1/landings/ | Landings Group Patch
*DefaultApi* | [**landings_list_v1_landings_get**](docs/DefaultApi.md#landings_list_v1_landings_get) | **GET** /v1/landings/ | Landings List
*DefaultApi* | [**landings_patch_v1_landings_landing_id_patch**](docs/DefaultApi.md#landings_patch_v1_landings_landing_id_patch) | **PATCH** /v1/landings/{landing_id} | Landings Patch
*DefaultApi* | [**landings_publish_v1_landings_landing_id_publish_post**](docs/DefaultApi.md#landings_publish_v1_landings_landing_id_publish_post) | **POST** /v1/landings/{landing_id}/publish | Landings Publish
*DefaultApi* | [**landings_recover_v1_landings_landing_id_recover_post**](docs/DefaultApi.md#landings_recover_v1_landings_landing_id_recover_post) | **POST** /v1/landings/{landing_id}/recover | Landings Recover
*DefaultApi* | [**landings_unpublish_v1_landings_landing_id_unpublish_post**](docs/DefaultApi.md#landings_unpublish_v1_landings_landing_id_unpublish_post) | **POST** /v1/landings/{landing_id}/unpublish | Landings Unpublish
*DefaultApi* | [**landings_update_v1_landings_landing_id_post**](docs/DefaultApi.md#landings_update_v1_landings_landing_id_post) | **POST** /v1/landings/{landing_id} | Landings Update
*DefaultApi* | [**submit_form_v1_forms_submit_post**](docs/DefaultApi.md#submit_form_v1_forms_submit_post) | **POST** /v1/forms/submit | Submit Form
*DefaultApi* | [**templates_add_v1_templates_post**](docs/DefaultApi.md#templates_add_v1_templates_post) | **POST** /v1/templates/ | Templates Add
*DefaultApi* | [**templates_count_v1_templates_count_get**](docs/DefaultApi.md#templates_count_v1_templates_count_get) | **GET** /v1/templates/count | Templates Count
*DefaultApi* | [**templates_delete_v1_templates_template_id_delete**](docs/DefaultApi.md#templates_delete_v1_templates_template_id_delete) | **DELETE** /v1/templates/{template_id} | Templates Delete
*DefaultApi* | [**templates_duplicate_v1_templates_template_id_duplicate_post**](docs/DefaultApi.md#templates_duplicate_v1_templates_template_id_duplicate_post) | **POST** /v1/templates/{template_id}/duplicate | Templates Duplicate
*DefaultApi* | [**templates_get_v1_templates_template_id_get**](docs/DefaultApi.md#templates_get_v1_templates_template_id_get) | **GET** /v1/templates/{template_id} | Templates Get
*DefaultApi* | [**templates_group_patch_v1_templates_patch**](docs/DefaultApi.md#templates_group_patch_v1_templates_patch) | **PATCH** /v1/templates/ | Templates Group Patch
*DefaultApi* | [**templates_import_v1_templates_template_id_import_post**](docs/DefaultApi.md#templates_import_v1_templates_template_id_import_post) | **POST** /v1/templates/{template_id}/import | Templates Import
*DefaultApi* | [**templates_list_v1_templates_get**](docs/DefaultApi.md#templates_list_v1_templates_get) | **GET** /v1/templates/ | Templates List
*DefaultApi* | [**templates_patch_v1_templates_template_id_patch**](docs/DefaultApi.md#templates_patch_v1_templates_template_id_patch) | **PATCH** /v1/templates/{template_id} | Templates Patch
*DefaultApi* | [**templates_publish_v1_templates_template_id_publish_post**](docs/DefaultApi.md#templates_publish_v1_templates_template_id_publish_post) | **POST** /v1/templates/{template_id}/publish | Templates Publish
*DefaultApi* | [**templates_recover_v1_templates_template_id_recover_post**](docs/DefaultApi.md#templates_recover_v1_templates_template_id_recover_post) | **POST** /v1/templates/{template_id}/recover | Templates Recover
*DefaultApi* | [**templates_unpublish_v1_templates_template_id_unpublish_post**](docs/DefaultApi.md#templates_unpublish_v1_templates_template_id_unpublish_post) | **POST** /v1/templates/{template_id}/unpublish | Templates Unpublish
*DefaultApi* | [**templates_update_v1_templates_template_id_post**](docs/DefaultApi.md#templates_update_v1_templates_template_id_post) | **POST** /v1/templates/{template_id} | Templates Update
*DefaultApi* | [**validate_form_v1_forms_validate_post**](docs/DefaultApi.md#validate_form_v1_forms_validate_post) | **POST** /v1/forms/validate | Validate Form


## Documentation For Models

 - [Address](docs/Address.md)
 - [FormGet](docs/FormGet.md)
 - [FormGroupPatch](docs/FormGroupPatch.md)
 - [FormListGet](docs/FormListGet.md)
 - [FormNew](docs/FormNew.md)
 - [FormPatch](docs/FormPatch.md)
 - [FormSubmitRequest](docs/FormSubmitRequest.md)
 - [FormUpdate](docs/FormUpdate.md)
 - [FormValidateRequest](docs/FormValidateRequest.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [IdWrapper](docs/IdWrapper.md)
 - [InputField](docs/InputField.md)
 - [LandingGet](docs/LandingGet.md)
 - [LandingGroupPatch](docs/LandingGroupPatch.md)
 - [LandingHistoryGet](docs/LandingHistoryGet.md)
 - [LandingHistoryListGet](docs/LandingHistoryListGet.md)
 - [LandingListGet](docs/LandingListGet.md)
 - [LandingNew](docs/LandingNew.md)
 - [LandingPatch](docs/LandingPatch.md)
 - [LandingUpdate](docs/LandingUpdate.md)
 - [OptinMethod](docs/OptinMethod.md)
 - [ParsedForm](docs/ParsedForm.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperFormGet](docs/ResponseWrapperFormGet.md)
 - [ResponseWrapperIdWrapper](docs/ResponseWrapperIdWrapper.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperLandingGet](docs/ResponseWrapperLandingGet.md)
 - [ResponseWrapperLandingHistoryGet](docs/ResponseWrapperLandingHistoryGet.md)
 - [ResponseWrapperListFormListGet](docs/ResponseWrapperListFormListGet.md)
 - [ResponseWrapperListLandingHistoryListGet](docs/ResponseWrapperListLandingHistoryListGet.md)
 - [ResponseWrapperListLandingListGet](docs/ResponseWrapperListLandingListGet.md)
 - [ResponseWrapperListTemplateListGet](docs/ResponseWrapperListTemplateListGet.md)
 - [ResponseWrapperParsedForm](docs/ResponseWrapperParsedForm.md)
 - [ResponseWrapperTemplateGet](docs/ResponseWrapperTemplateGet.md)
 - [Result](docs/Result.md)
 - [TemplateGet](docs/TemplateGet.md)
 - [TemplateGroupPatch](docs/TemplateGroupPatch.md)
 - [TemplateListGet](docs/TemplateListGet.md)
 - [TemplateNew](docs/TemplateNew.md)
 - [TemplatePatch](docs/TemplatePatch.md)
 - [TemplateUpdate](docs/TemplateUpdate.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication


## Author




