# fal-ai-connector
FastAPI connector for fal.ai video generation using Wan 2.6 model

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.1.0+2253467561
- Generator version: 7.18.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import fal_ai_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import fal_ai_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import fal_ai_connector
from fal_ai_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = fal_ai_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with fal_ai_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = fal_ai_connector.VideoGenerationApi(api_client)
    image_to_video_api_request = fal_ai_connector.ImageToVideoApiRequest() # ImageToVideoApiRequest | 

    try:
        # Generate video from image
        api_response = await api_instance.generate_video_from_image_video_v1_image_to_video_post(image_to_video_api_request)
        print("The response of VideoGenerationApi->generate_video_from_image_video_v1_image_to_video_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling VideoGenerationApi->generate_video_from_image_video_v1_image_to_video_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*VideoGenerationApi* | [**generate_video_from_image_video_v1_image_to_video_post**](docs/VideoGenerationApi.md#generate_video_from_image_video_v1_image_to_video_post) | **POST** /video/v1/image_to_video | Generate video from image
*VideoGenerationApi* | [**generate_video_from_text_video_v1_text_to_video_post**](docs/VideoGenerationApi.md#generate_video_from_text_video_v1_text_to_video_post) | **POST** /video/v1/text_to_video | Generate video from text


## Documentation For Models

 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ImageToVideoApiRequest](docs/ImageToVideoApiRequest.md)
 - [TextToVideoApiRequest](docs/TextToVideoApiRequest.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [VideoApiResponse](docs/VideoApiResponse.md)
 - [VideoDuration](docs/VideoDuration.md)
 - [VideoOutputResponse](docs/VideoOutputResponse.md)
 - [VideoPreset](docs/VideoPreset.md)
 - [WrappedResponseVideoApiResponse](docs/WrappedResponseVideoApiResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




