# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from ai_assistant_server_connector.models.assistant_function import AssistantFunction
from ai_assistant_server_connector.models.conversation_style import ConversationStyle
from ai_assistant_server_connector.models.knowledgebase_state import KnowledgebaseState

class AiAssistantListGet(BaseModel):
    """
    AiAssistantListGet
    """
    id: StrictInt = Field(...)
    is_active: StrictBool = Field(...)
    is_live: StrictBool = Field(...)
    conversation_style: ConversationStyle = Field(...)
    function: AssistantFunction = Field(...)
    avatar_id: Optional[StrictStr] = None
    voice_id: StrictInt = Field(...)
    name: StrictStr = Field(...)
    allow_text: StrictBool = Field(...)
    allow_voice: StrictBool = Field(...)
    prefer_voice: StrictBool = Field(...)
    system_prompt: Optional[StrictStr] = None
    system_prompt_support: Optional[StrictStr] = None
    system_prompt_tutor: Optional[StrictStr] = None
    conversation_starter: Optional[StrictStr] = None
    created_at: StrictInt = Field(...)
    last_updated_at: StrictInt = Field(...)
    deleted_at: Optional[StrictInt] = None
    is_available: Optional[StrictBool] = False
    knowledgebase_state: Optional[KnowledgebaseState] = None
    __properties = ["id", "is_active", "is_live", "conversation_style", "function", "avatar_id", "voice_id", "name", "allow_text", "allow_voice", "prefer_voice", "system_prompt", "system_prompt_support", "system_prompt_tutor", "conversation_starter", "created_at", "last_updated_at", "deleted_at", "is_available", "knowledgebase_state"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AiAssistantListGet:
        """Create an instance of AiAssistantListGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of knowledgebase_state
        if self.knowledgebase_state:
            _dict['knowledgebase_state'] = self.knowledgebase_state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AiAssistantListGet:
        """Create an instance of AiAssistantListGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AiAssistantListGet.parse_obj(obj)

        _obj = AiAssistantListGet.parse_obj({
            "id": obj.get("id"),
            "is_active": obj.get("is_active"),
            "is_live": obj.get("is_live"),
            "conversation_style": obj.get("conversation_style"),
            "function": obj.get("function"),
            "avatar_id": obj.get("avatar_id"),
            "voice_id": obj.get("voice_id"),
            "name": obj.get("name"),
            "allow_text": obj.get("allow_text"),
            "allow_voice": obj.get("allow_voice"),
            "prefer_voice": obj.get("prefer_voice"),
            "system_prompt": obj.get("system_prompt"),
            "system_prompt_support": obj.get("system_prompt_support"),
            "system_prompt_tutor": obj.get("system_prompt_tutor"),
            "conversation_starter": obj.get("conversation_starter"),
            "created_at": obj.get("created_at"),
            "last_updated_at": obj.get("last_updated_at"),
            "deleted_at": obj.get("deleted_at"),
            "is_available": obj.get("is_available") if obj.get("is_available") is not None else False,
            "knowledgebase_state": KnowledgebaseState.from_dict(obj.get("knowledgebase_state")) if obj.get("knowledgebase_state") is not None else None
        })
        return _obj


