# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from public_api_server_connector.models.button_position import ButtonPosition
from public_api_server_connector.models.button_size import ButtonSize
from public_api_server_connector.models.button_target import ButtonTarget

class Content(BaseModel):
    """
    Content
    """
    link: Optional[StrictStr] = Field(default=None, description="Link to the content, e.g. YouTube video link")
    file_id: Optional[StrictStr] = Field(default=None, description="File id from the file storage service")
    payload: Optional[StrictStr] = Field(default=None, description="Raw content payload, e.g. HTML or text content")
    btn_url: Optional[StrictStr] = Field(default=None, description="Button URL, has to be set if the block is a button")
    btn_font: Optional[StrictStr] = Field(default=None, description="Button font, if not set, default font (Public Sans) is used")
    btn_size: Optional[ButtonSize] = Field(default=None, description="Button size, if not set, default (medium) size is used")
    btn_text: Optional[StrictStr] = Field(default=None, description="Button text, has to be set if the block is a button")
    btn_color: Optional[StrictStr] = Field(default=None, description="Button color in hex format, default (#415BF5) is used if not set")
    btn_target: Optional[ButtonTarget] = Field(default=None, description="Button target url, default (_blank) is used if not set")
    btn_position: Optional[ButtonPosition] = Field(default=None, description="Button position, default (center) is used if not set")
    btn_text_color: Optional[StrictStr] = Field(default=None, description="Button text color, default (#FFFFFF) is used if not set")
    pdf_id: Optional[StrictStr] = Field(default=None, description="PDF file id from the file storage service, file is served read-only")
    __properties = ["link", "file_id", "payload", "btn_url", "btn_font", "btn_size", "btn_text", "btn_color", "btn_target", "btn_position", "btn_text_color", "pdf_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Content:
        """Create an instance of Content from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Content:
        """Create an instance of Content from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Content.parse_obj(obj)

        _obj = Content.parse_obj({
            "link": obj.get("link"),
            "file_id": obj.get("file_id"),
            "payload": obj.get("payload"),
            "btn_url": obj.get("btn_url"),
            "btn_font": obj.get("btn_font"),
            "btn_size": obj.get("btn_size"),
            "btn_text": obj.get("btn_text"),
            "btn_color": obj.get("btn_color"),
            "btn_target": obj.get("btn_target"),
            "btn_position": obj.get("btn_position"),
            "btn_text_color": obj.get("btn_text_color"),
            "pdf_id": obj.get("pdf_id")
        })
        return _obj


