#  Copyright (C) 2024
#  ABM JSC, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Albakov Ruslan <r.albakov@abm-jsc.ru>
from contextlib import asynccontextmanager
from typing import Hashable

from .abstract_semaphore import AbstractSemaphore
from .semaphore_wrapper import SemaphoreWrapper


class KeySemaphore(AbstractSemaphore):
    def __init__(self) -> None:
        self._key_to_semaphore: dict[Hashable, SemaphoreWrapper] = {}

    @asynccontextmanager
    async def restrict(self, key: Hashable, concurrency_limit: int = 1) -> None:
        semaphore_wrapper = self._key_to_semaphore.setdefault(key, SemaphoreWrapper(concurrency_limit))
        await semaphore_wrapper.acquire()
        try:
            yield
        finally:
            semaphore_wrapper.release()
            if not semaphore_wrapper.depth:
                del self._key_to_semaphore[key]
