# Http tools

Async http server as component

Usage:

```python
import asyncio
import aiohttp

from http_tools import HttpServer, SerializableAnswer

async def amain():
    server: HttpServer = HttpServer(HttpServer.Config('localhost', port=8080))
    server.register_handler('/echo', lambda x: SerializableAnswer(x.key_value_arguments))
    session = aiohttp.ClientSession()
    try:
        await server._on_start()
        response = await session.get('http://localhost:8080/echo', params={'test': 'passed'})
        answer = await response.json()
        assert answer['result']['test'] == 'passed'

    finally:
        await session.close()
        await server._on_stop()

asyncio.run(amain())
```
