#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mikhail Marokin <m.marokin@abm-jsc.ru>


from dataclasses import dataclass
from detector_image_box import ImageBox


@dataclass
class FilledImageBox(ImageBox):
    filled_percent: float

    def calculate_detection_percent(self, settings_image_boxes: list[ImageBox]) -> float:
        intersection_overexpose_percent: float = 0
        detector_box_area_percent = self.box_area_percent
        for settings_image_box in settings_image_boxes:
            intersection_box = self.get_intersection_box(settings_image_box)
            if not intersection_box:
                continue
            settings_box_filled_percent = getattr(settings_image_box, "filled_percent", 1.0)
            intersection_unfilled_percent = self.filled_percent * (1 - settings_box_filled_percent)

            detector_box_area_percent -= intersection_box.box_area_percent
            if detector_box_area_percent < 0:
                detector_box_area_percent = 0

            intersection_overexpose_percent += intersection_box.box_area_percent * intersection_unfilled_percent

        return intersection_overexpose_percent + detector_box_area_percent * self.filled_percent
