#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mikhail Marokin <m.marokin@abm-jsc.ru>


from dataclasses import dataclass
from typing import Optional


@dataclass
class ImageBox:
    left_up_x_percentage: float
    left_up_y_percentage: float
    right_bottom_x_percentage: float
    right_bottom_y_percentage: float

    @property
    def box_area_percent(self) -> float:
        return (
                (self.right_bottom_x_percentage - self.left_up_x_percentage)
                * (self.right_bottom_y_percentage - self.left_up_y_percentage)
        )

    def get_intersection_box(self, other: 'ImageBox') -> Optional['ImageBox']:
        left = max(self.left_up_x_percentage, other.left_up_x_percentage)
        top = max(self.left_up_y_percentage, other.left_up_y_percentage)
        right = min(self.right_bottom_x_percentage, other.right_bottom_x_percentage)
        bottom = min(self.right_bottom_y_percentage, other.right_bottom_y_percentage)

        intersection_box_width = right - left
        intersection_box_height = bottom - top

        if intersection_box_width < 0 or intersection_box_height < 0:
            return None
        else:
            intersection_box = ImageBox(
                left_up_x_percentage=left,
                left_up_y_percentage=top,
                right_bottom_x_percentage=right,
                right_bottom_y_percentage=bottom
            )
            return intersection_box
