# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from landing_page_server_connector.models.lesson_type_str_enum import LessonTypeStrEnum
from landing_page_server_connector.models.module_lesson_update_content_blocks_inner import ModuleLessonUpdateContentBlocksInner

class ModuleLessonUpdate(BaseModel):
    """
    ModuleLessonUpdate
    """
    submodule_id: Optional[StrictInt] = None
    thread_id: Optional[StrictInt] = None
    lesson_type: LessonTypeStrEnum = Field(...)
    image_id: Optional[StrictStr] = None
    title: StrictStr = Field(...)
    payload: Optional[StrictStr] = ''
    is_active: StrictBool = Field(...)
    is_published: StrictBool = Field(...)
    mandatory: StrictBool = Field(...)
    available_at: Optional[StrictInt] = None
    available_in: Optional[StrictInt] = None
    order: StrictInt = Field(...)
    content_blocks: conlist(ModuleLessonUpdateContentBlocksInner) = Field(default=..., description="List of content blocks to update or create")
    __properties = ["submodule_id", "thread_id", "lesson_type", "image_id", "title", "payload", "is_active", "is_published", "mandatory", "available_at", "available_in", "order", "content_blocks"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModuleLessonUpdate:
        """Create an instance of ModuleLessonUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in content_blocks (list)
        _items = []
        if self.content_blocks:
            for _item in self.content_blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['content_blocks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModuleLessonUpdate:
        """Create an instance of ModuleLessonUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ModuleLessonUpdate.parse_obj(obj)

        _obj = ModuleLessonUpdate.parse_obj({
            "submodule_id": obj.get("submodule_id"),
            "thread_id": obj.get("thread_id"),
            "lesson_type": obj.get("lesson_type"),
            "image_id": obj.get("image_id"),
            "title": obj.get("title"),
            "payload": obj.get("payload") if obj.get("payload") is not None else '',
            "is_active": obj.get("is_active"),
            "is_published": obj.get("is_published"),
            "mandatory": obj.get("mandatory"),
            "available_at": obj.get("available_at"),
            "available_in": obj.get("available_in"),
            "order": obj.get("order"),
            "content_blocks": [ModuleLessonUpdateContentBlocksInner.from_dict(_item) for _item in obj.get("content_blocks")] if obj.get("content_blocks") is not None else None
        })
        return _obj


