import enum
from enum import unique
from typing import Type

from jinja2 import Environment, Undefined


@unique
class EmailTemplateLanguage(enum.StrEnum):
    ru = "ru"
    en = "en"


class SilentUndefined(Undefined):
    def _fail_with_undefined_error(self, *args, **kwargs) -> str:
        """Skip an :exc:`UndefinedError` when operations are performed
        on the undefined value.
        """
        return ""


class TemplateProvider:
    def __init__(self):
        self._environment = Environment(undefined=SilentUndefined)

    async def get_nested_template(self, nested_template_register: Type):
        pass
    #
    # @abstractmethod
    # async def get_template(self, code: EmailTemplateCode, language: EmailTemplateLanguage) -> EmailTemplate:
    #     pass
