#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import asyncio
from typing import Awaitable, TypeVar

K = TypeVar("K")
V = TypeVar("V")


async def strict_gather(*awaitables: Awaitable[V]) -> tuple[V]:
    futures = [asyncio.ensure_future(awaitable) for awaitable in awaitables]
    try:
        return await asyncio.gather(*futures)
    except Exception as e:
        for future in futures:
            future.cancel()
        raise e
