from dataclasses import dataclass
from enum import Enum, unique


@unique
class FilterOperator(str, Enum):
    eq = "="
    gt = ">"
    lw = "<"
    in_ = "in"
    ilike = "ilike"
    is_null = "is_null"


@dataclass
class EntityFilter:
    column: str
    operator: FilterOperator
    value: any


