## Overview

Client for old file server with int ids

## Library Installation

## pip installation
```
pip install --extra-index-url https://pypi.abm-jsc.ru file-server-connector-legacy-abm
```

## poetry installation

```
poetry source add --secondary abm-jsc-pypi https://pypi2.abm-jsc.ru
poetry add --source abm-jsc-pypi file-server-connector-legacy-abm
```

## Quick Start


#### Connector usage

```python
#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>

import asyncio

import aiohttp
from aiohttp.web_exceptions import HTTPNotFound

from file_server_connector_legacy.server_name_auth_file_server_connector import ServerNameLegacyFileServerConnector


async def connector_test():
    session = aiohttp.ClientSession()

    file_service_connector = ServerNameLegacyFileServerConnector(
        config=ServerNameLegacyFileServerConnector.Config(
            server_name='my_service',
            url='127.0.0.1:8090',
        ),
        context=ServerNameLegacyFileServerConnector.Context(
            session=session,
        ),
    )
    file = b" some_file"
    file_info = await file_service_connector.add_file(file, "test_name")
    print(f"""
    add_file answer : {file_info}
    """)
    requested_file = await file_service_connector.get_file(file_info["id"])
    print(f"""
    uploaded_file: {file}
    requested_file: {requested_file}
    is_same: {requested_file == file}
          """)
    requested_file_info = await file_service_connector.get_file_info(file_info["id"])
    print(f"""
    requested_file_info : {requested_file_info}
    is_same : {requested_file_info == file_info}
    """)

    await file_service_connector.delete_file(file_info["id"])

    try:
        await file_service_connector.get_file_info(file_info["id"])
    except HTTPNotFound as e:
        print(f"file not found: {repr(e)}")
    await session.close()


asyncio.run(connector_test())

```
