#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Revva Konstantin <k.revva@abm-jsc.ru>


from dataclasses import dataclass

from http_tools import AbmServiceConnector


class DetectorHttpConnector:
    @dataclass(kw_only=True)
    class Config(AbmServiceConnector.Config):
        project_name: str

    Context = AbmServiceConnector.Context

    def __init__(self, config: Config, context: Context) -> None:
        self.config = config
        self._connector = AbmServiceConnector(config, context)

    async def correct_settings(self, stream_url: str, correct_file_id: str, token: str) -> bool:
        payload = {
                "correct_file_id": correct_file_id,
                "token": token,
                "stream_url": stream_url
        }
        answer = await self._connector.post("/settings/correct", payload=payload, headers=self._construct_headers())
        return answer["done"]

    def _construct_headers(self) -> dict[str, str]:
        return {"server_name": self.config.server_name}
