#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
import logging
from configparser import ConfigParser
from typing import Dict

logger = logging.getLogger(__file__)


def read_ini_file_by_path(path: str) -> Dict[str, Dict[str, str]]:
    logger.info(f"Attempt to read ini file by {path=}")
    config = ConfigParser()
    red = config.read(path)
    if not red:
        raise FileNotFoundError(path)
    return {name: {key: config[name][key] for key in config[name]} for name in config.sections()}
