#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import TypeVar, MutableMapping, Callable, Any

from init_helpers.is_none import is_not_none


T = TypeVar('T')
Condition = Callable[[T], bool]


def conditional_set(mapping: MutableMapping[str, Any], *, _condition: Condition = is_not_none, **kwargs: T) -> None:
    for key, value in kwargs.items():
        if _condition(value):
            mapping[key] = value


def conditional_append(list_: list, *args: T, _condition: Condition = is_not_none) -> None:
    for value in args:
        if _condition(value):
            list_.append(value)


def conditional_add(set_: set, *args: T, _condition: Condition = is_not_none) -> None:
    for value in args:
        if _condition(value):
            set_.add(value)


def set_if(condition: bool, mapping: MutableMapping[str, Any], **kwargs: Any) -> None:
    if condition:
        for key, value in kwargs.items():
            mapping[key] = value


def append_if(condition: bool, list_: list[Any], *args: Any) -> None:
    if condition:
        for value in args:
            list_.append(value)


def add_if(condition: bool, set_: set[Any], *args: Any) -> None:
    if condition:
        for value in args:
            set_.add(value)
