#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import asyncio
import sys
import tempfile
from pathlib import Path

from run_markdown import get_logic_block_from_md_file


async def main():
    assert len(sys.argv) > 1
    target_file = sys.argv[1]
    timeout = 1
    if len(sys.argv) > 2:
        timeout_str = sys.argv[2]
        try:
            timeout = float(timeout_str)
        except ValueError:
            raise ValueError(f'Failed to convert {timeout_str!r} to float timeout') from None
    block = get_logic_block_from_md_file(target_file)
    try:
        with tempfile.TemporaryDirectory() as tmp_dir_name:
            await block.evaluate(tmp_dir=Path(tmp_dir_name), timeout=timeout)
    except Exception as e:
        print("CHECK FAILED")
        print(repr(e))
        exit(1)
    print("CHECK SUCCESS")


if __name__ == '__main__':
    asyncio.run(main())
