#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import dataclass

from entity_read.sql.context import SqlContext

SQL = str


@dataclass(kw_only=True, frozen=True)
class Node(abc.ABC):
    # TODO: replace key_to_expression with "existent attributes", where present table columns and relations
    @abc.abstractmethod
    def to_sql(self, context: SqlContext, key_to_expression: dict = None) -> SQL:
        ...

    @abc.abstractmethod
    def requires(self) -> list:
        ...
