#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import typing
from dataclasses import dataclass

# from entity_read.select.atoms.atoms import NodeType
from .abstract import Selectable
from .column import Column


@dataclass(kw_only=True, frozen=True)
class Literal(Selectable):
    # type = NodeType.literal
    value: typing.Any
    # alias: str = None

    def to_sql(self, context, key_to_expression = None) -> str:
        if not context.bind_params:
            return context.register_parameter(self.value)

        value = list(self.value) if isinstance(self.value, set) else self.value
        result = str(value)
        if isinstance(value, list):
            if self.value:
                result = 'ARRAY' + result
            else:
                result = "'{}'"
        return result

    def requires(self) -> list['Column']:
        return []

    def get_name(self) -> str:
        return str(self.value)

    # def get_name(self) -> str:
    #     return self.alias


# @dataclass(kw_only=True, frozen=True)
# class EStringLiteral(ELiteral):
#     value: str
#
#
# @dataclass(kw_only=True, frozen=True)
# class EIntegerLiteral(ELiteral):
#     value: int
