#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass, field

# from ..node import NodeType
from entity_read.sql.atoms.node import Node
from .abstract import Selectable
from .column import Column


@dataclass(kw_only=True, frozen=True)
class Alias(Selectable):
    body: Selectable
    key: str

    def __init__(self, *, body: Selectable, key: str):
        object.__setattr__(self, 'body', body)
        object.__setattr__(self, 'key', key)

    @property
    def type_(self) -> type:
        return self.body.type_

    @property
    def is_nullable(self) -> bool:
        return self.body.is_nullable

    def to_sql(self, context, key_to_expression = None) -> str:
        return self.body.to_sql(context, key_to_expression)

    def requires(self) -> list['Column']:
        return self.body.requires()

    def get_name(self) -> str:
        return self.key
