#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import dataclass
from typing import TypeVar, Generic, Type

from entity_read.sql.atoms.node import Node

T = TypeVar('T')


@dataclass(kw_only=True, frozen=True)
class Selectable(Generic[T], Node, abc.ABC):
    type_: Type[T]
    is_nullable: bool = False

    @abc.abstractmethod
    def get_name(self) -> str:
        ...
