#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc

from http_tools import IncomingRequest

from .abstract import AbstractActorProvider
from ..actor.abstract import AbstractActor


class AbstractHttpActorProvider(AbstractActorProvider, abc.ABC):
    @abc.abstractmethod
    async def get_actor(self, incoming_request: IncomingRequest) -> AbstractActor:
        pass
