#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from sqlalchemy_tools.utils.text import camel_case_to_underscore

from entity_tools.entity import Entity


def ensure_tablename(entity_type: type[Entity], table_name: str = None) -> None:
    if table_name:
        entity_type.__tablename__ = table_name
    if not entity_type.__tablename__:
        entity_type.__tablename__ = camel_case_to_underscore(entity_type.__name__)
