#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from ..node import SQL
from .abstract import Selectable


@dataclass
class EColumn(Selectable):
    # type = NodeType.column
    value: str
    # alias: str = None

    def to_sql(self, context, key_to_expression = None) -> SQL:
        key_to_expression = {} if key_to_expression is None else key_to_expression
        result = key_to_expression[self.value] if self.value in key_to_expression else f'{context.get_self()}.{self.value}'
        return result

    def requires(self) -> list['EColumn']:
        return [self]

    def get_name(self) -> str:
        return self.value
